{********************************************
; File: TextTool.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT TEXTTOOL;
INTERFACE
USES TYPES;
CONST

{ Error Codes }
badDevType = $0C01;  { not implemented }
badDevNum = $0C02;  { Illegal device number. }
badMode = $0C03;  { Bad mode: illegal operation. }
unDefHW = $0C04;  { Undefined hardware error }
lostDev = $0C05;  { Lost device: Device no longer on line }
lostFile = $0C06;  { File no longer in diskette directory }
badTitle = $0C07;  { Illegal Filename }
noRoom = $0C08;  { Insufficient space on specified diskette }
noDevice = $0C09;  { Volume not online }
noFile = $0C0A;  { File not in specifiled directory }
dupFile = $0C0B;  { Filename already exists }
notClosed = $0C0C;  { Attempt to open an open file }
notOpen = $0C0D;  { Attempt to close closed file }
badFormat = $0C0E;  { error reading real or integer }
ringBuffOFlo = $0C0F;  { Chars arriving too fast }
writeProtected = $0C10;
devErr = $0C40;  { Read or Write failed }

{ deviceNum Codes }
input = $0000;
output = $0001;
errorOutput = $0002;

{ deviceType Codes }
basicType = $0000;
pascalType = $0001;
ramBased = $0002;

{ echoFlag Codes }
noEcho = $0000;
echo = $0001;
TYPE
DeviceRecHndl = ^DeviceRecPtr;
DeviceRecPtr = ^DeviceRec;
DeviceRec = RECORD
    ptrOrSlot : Longint; { slot number or jump table ptr }
    deviceType : Integer; { type of input device }
END;
TxtMaskRecHndl = ^TxtMaskRecPtr;
TxtMaskRecPtr = ^TxtMaskRec;
TxtMaskRec = RECORD
    orMask : Integer;
    andMask : Integer;
END;
PROCEDURE CtlTextDev ( deviceNum:Integer; controlCode:Integer)  ;
PROCEDURE ErrWriteBlock ( textPtr:Ptr; offset:Integer; count:Integer)  ;
PROCEDURE ErrWriteChar ( theChar:Integer)  ;
PROCEDURE ErrWriteCString ( cStrPtr:CStringPtr)  ;
PROCEDURE ErrWriteLine ( str:Str255)  ;
PROCEDURE ErrWriteString ( str:Str255)  ;
FUNCTION GetErrGlobals  : TxtMaskRec ;
FUNCTION GetErrorDevice  : DeviceRec ;
FUNCTION GetInGlobals  : TxtMaskRec ;
FUNCTION GetInputDevice  : DeviceRec ;
FUNCTION GetOutGlobals  : TxtMaskRec ;
FUNCTION GetOutputDevice  : DeviceRec ;
PROCEDURE InitTextDev ( deviceNum:Integer)  ;
FUNCTION ReadChar ( echoFlag:Integer) : Integer ;
FUNCTION ReadLine ( bufferPtr:Ptr; maxCount:Integer; eolChar:Integer; echoFlag:Integer) : Integer ;
PROCEDURE SetErrGlobals ( andMask:Integer; orMask:Integer)  ;
PROCEDURE SetErrorDevice ( deviceType:Integer; ptrOrSlot:Longint)  ;
PROCEDURE SetInGlobals ( andMask:Integer; orMask:Integer)  ;
PROCEDURE SetInputDevice ( deviceType:Integer; ptrOrSlot:Longint)  ;
PROCEDURE SetOutGlobals ( andMask:Integer; orMask:Integer)  ;
PROCEDURE SetOutputDevice ( deviceType:Integer; ptrOrSlot:Longint)  ;
PROCEDURE StatusTextDev ( deviceNum:Integer; requestCode:Integer)  ;
PROCEDURE TextBootInit   ;
PROCEDURE TextReadBlock ( bufferPtr:Ptr; offset:Integer; blockSize:Integer; echoFlag:Integer)  ;
PROCEDURE TextReset   ;
PROCEDURE TextShutDown   ;
PROCEDURE TextStartUp   ;
FUNCTION TextStatus  : Boolean ;
FUNCTION TextVersion  : Integer ;
PROCEDURE TextWriteBlock ( textPtr:Ptr; offset:Integer; count:Integer)  ;
PROCEDURE WriteChar ( theChar:Integer)  ;
PROCEDURE WriteCString ( cStrPtr:CStringPtr)  ;
PROCEDURE WriteLine ( str:Str255)  ;
PROCEDURE WriteString ( str:Str255)  ;
IMPLEMENTATION
END.
